import java.awt.event.KeyEvent;

public class KeyEventProcessor
{
	private char KeyPressed;
	private int KeyCodePressed;
	private char KeyTyped;
	private boolean ControlPressed;
	private boolean ShiftPressed;

	public KeyEventProcessor(MainWindow MainWindow)
	{
		KeyPressed = '\0';
		KeyCodePressed = 0;
		ControlPressed = false;
		ShiftPressed = false;
	}

	public boolean AnyKeyPressed()
	{
		return (KeyCodePressed != 0);
	}

	public boolean AnyKeyTyped()
	{
		return (KeyTyped != '\0');
	}

	public void ClearKeyCodePressed()
	{
		KeyCodePressed = 0;
	}
	
	public void ClearKeyTyped()
	{
		KeyTyped = '\0';
	}

	/* // keyPressed() is not reliable if Control or Shift is down at the same time, Java docs say, always use GetKeyCodePressed() instead!
	public char GetKeyPressed()
	{
		return KeyPressed;
	}
	*/

	public int GetKeyCodePressed()
	{
		return KeyCodePressed;
	}

	public char GetKeyTyped()
	{
		return KeyTyped;
	}

	public boolean IsControlPressed()
	{
		return ControlPressed;
	}

	/*
	public boolean IsKeyPressed(char Key)
	{
		return (GetKeyPressed() == Key);
	}
	*/

	public boolean IsKeyCodePressed(int KeyCode)
	{
		return (GetKeyCodePressed() == KeyCode);
	}

	public boolean IsKeyTyped(char Key)
	{
		return (GetKeyTyped() == Key);
	}

	public boolean IsShiftPressed()
	{
		return ShiftPressed;
	}

	public void keyPressed(KeyEvent e)
	{
		// when it's pressed, it's not YET typed (else system screwed, tested)!

		KeyPressed = e.getKeyChar();
		KeyCodePressed = e.getKeyCode();
		ControlPressed = e.isControlDown();
		ShiftPressed = e.isShiftDown();
	}

	public void keyReleased(KeyEvent eOrNull)
	{
		// when it's released, it's not YET typed (else system screwed, tested)!

		KeyPressed = '\0';
		KeyCodePressed = 0;
		ControlPressed = false;
		ShiftPressed = false;
	}

	public void keyTyped(KeyEvent e)
	{
		KeyTyped = e.getKeyChar();

		ControlPressed = false;
		ShiftPressed = false;
	}
}
